//////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// This code will only run on a machine with a correctly installed and configured OpenCV library
//
// This code consists of three algorithms; License plate detection, segmentation
// and character recognition.
//
// This code is not yet completely designed to work automatically. Currently the
// three algorithms should be executed separately. But one may test the detection
// and segmentation algorithms together. To test the detection algorithm
// an input image must be supplied manually into this code. The segmentation algorithm
// will follow right after detection is complete. To test both independently, some code
// has to be commented out and some changes have to be made to the code. 
//
// To run the character recognition algorithm one must also provide an input license plate
// image. *Please note that all of the templates have not been loaded in this code.
//
// NOTE*: Please ignore other commented out code. That code is part of different experiments. 
//////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <opencv2/core/core.hpp>
#include <opencv2/opencv.hpp>
#include <opencv2/highgui/highgui.hpp>
#include "opencv2/imgproc/imgproc.hpp"
#include "gpu/gpu.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <cv.h>
#include <iostream>
using namespace cv;
using namespace std;

RNG rng(12345);


/*void isPlate(Mat c) {

	//vector<vector<Mat>> nump(rectsIndex.size());
	//vector<RotatedRect> minRect( contours.size() );
	//vector<RotatedRect> minRect2( contours.size() );
	vector<Mat> seg;
	Mat img = c.clone();
	//resize(c, c, Size(360, 125));
	threshold(c, c, 0, 255, CV_THRESH_BINARY_INV+CV_THRESH_OTSU);
	Mat element = getStructuringElement( MORPH_RECT, Size(5, 5)); // Create 
	//erode(c, c, element);

	//resize(c, c, Size(360, 125));
	imwrite( "platee4.jpg", c );
	imshow("seg", c);
	vector<vector<Point> > contours;
	vector<Vec4i> hierarchy;
	findContours( c, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );

	vector<RotatedRect> minRect( contours.size() );

	Mat draw = Mat::zeros( c.size(), CV_8UC3 );

	for(int i=0; i < contours.size(); i++) {
		
		
		minRect[i] = (minAreaRect( Mat(contours[i]) ));	
		//if(minRect[i].boundingRect().area() < 6000 && minRect[i].boundingRect().area() > 1000) {
			Scalar color = Scalar( rng.uniform(0, 255), rng.uniform(0,255), rng.uniform(0,255) );
			drawContours( draw, contours, i, color, 2, 8, hierarchy, 0, Point() );

			printf("%d   ||||  ", minRect[i].boundingRect().area());
	//	}
		//seg[i] = Mat(img(minRect[i].boundingRect()));
		//imshow("seg"+i, Mat(img(minRect[i].boundingRect())));
	}
	imwrite( "segmentation4.jpg", draw );
	imshow("wer", draw);
	//imshow("seg", Mat(img(minRect[0].boundingRect())));

	//return true;
}
*/


//int main() {
//
//	Mat image = imread("image.jpeg", CV_LOAD_IMAGE_GRAYSCALE);  // Load image
//	Mat image2 = imread("image.jpeg", CV_LOAD_IMAGE_GRAYSCALE); // Load image again
//	Mat image3 = imread("image.jpeg", CV_LOAD_IMAGE_GRAYSCALE); 
//	Mat image4 = imread("image.jpeg");
//
//	//namedWindow("Pleasework", WINDOW_NORMAL);
//	//resize(image, image, Size(800, 600));
//	//resize(image2, image2, Size(800, 600));
//	//resize(image3, image3, Size(800, 600));
//
//	GaussianBlur(image, image,	Size(5, 5), 2, 2); // Apply blur to smoothen the image
//	Sobel(image, image, CV_8U, 1, 0, 3, 1, 0); // Apply sobel filter to detect edges in the image and make them dominant
//	//imshow( "Pleasework", image);
//	
//
//	Mat element = getStructuringElement( MORPH_RECT, Size(30, 6)); // Create 
//	morphologyEx(image, image, 3, element);
//	
//
//	threshold(image, image, 0, 255, CV_THRESH_OTSU);
//	
//
//	element = getStructuringElement( MORPH_RECT, Size(30, 6));
//	erode(image, image, element);
//	element = getStructuringElement( MORPH_RECT, Size(40, 20));
//	dilate(image, image, element);
//	//imwrite( "erodedilate.jpg", image );
//	//imwrite( "localizing4.jpg", image );
//	//namedWindow("Plesework", 0);
//	//imshow( "Plesework", image);
//
//	vector<vector<Point> > contours;
//	vector<Vec4i> hierarchy;
//	findContours( image, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
//	
//	vector<RotatedRect> minRect( contours.size() );
//	/// Draw contours
//
//	Mat drawing = Mat::zeros( image.size(), CV_8UC3 );
//
//	vector<int> rectsIndex;
//
//	for( int i = 0; i < contours.size(); i++ )
//     { minRect[i] = minAreaRect( Mat(contours[i]) );}
//
//	for( int i = 0; i< contours.size(); i++ )
//	{
//		Scalar color = Scalar( rng.uniform(0, 255), rng.uniform(0,255), rng.uniform(0,255) );
//		drawContours( drawing, contours, i, color, 2, 8, hierarchy, 0, Point() );
//		
//		Rect bR=minRect[i].boundingRect();
//		double g = bR.width/bR.height;//minRect[i].size.height;
//		//bool yes = minRect[i].size.width >= minRect[i].size.height;
//		bool yes = bR.width >= bR.height;
//		
//		if (yes && (abs(minRect[i].angle) > 80.0 || abs(minRect[i].angle) < 10.0) && (bR.area() > 5000.0) && (bR.area() < 15000.0) && (g < 3) && (g > 1)) {
//			Point2f rect_points[4]; minRect[i].points( rect_points );
//			for( int j = 0; j < 4; j++ )
//				line( image4, rect_points[j], rect_points[(j+1)%4], Scalar(0,0,255), 3, 8 );
//
//			rectsIndex.push_back(i);
//
//		}
//	}
//
//	imwrite( "contours.jpg", drawing );
//	Rect r = minRect[rectsIndex[2]].boundingRect();
//
//	//for(int i=0; i < rectsIndex.size(); i++)	{
//	////	if(minRect[rectsIndex[i]].boundingRect().area() > r.area()) {
//	////		r = minRect[rectsIndex[i]].boundingRect();
//	////	}
//	//	isPlate(image3(minRect[rectsIndex[i]].boundingRect()));
//	//}
//	isPlate(image3(minRect[rectsIndex[0]].boundingRect()));
//	//r.y -= 1;
//	//r.height += 2;
//	//isPlate(image3(r));
//	//cv::Rect myROI(10, 10, 100, 100);
//
//	//namedWindow("Pleasork", 1);
//	imwrite( "localized4.jpg", image4 );
//	//imshow( "Pleasork", image2);
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//	
//	
//
//	//Mat image = imread("plate4.jpg", CV_LOAD_IMAGE_GRAYSCALE);  // Load image
//	//Mat dst = image.clone();
//	//threshold(image, image, 0, 255, CV_THRESH_BINARY_INV+CV_THRESH_OTSU);
//	//Mat element = getStructuringElement( MORPH_ELLIPSE , Size(3, 3)); // Create 
//	//erode(image, image, element);
//
//
//	////thinningGuoHall(image);
//	//Mat image2 = imread("plate4.jpg", CV_LOAD_IMAGE_GRAYSCALE);  // Load image
//	//Mat image3 = imread("Image.jpg", CV_LOAD_IMAGE_GRAYSCALE);  // Load image
//	////Mat element = getStructuringElement( MORPH_ELLIPSE , Size(3, 3)); // Create 
//
//	////erode(image, image, element);
//	//Mat d = Mat::zeros( image.size(), CV_8UC3 );
//
//	////resize(image, image, Size(360, 125));
//	////resize(d, d, Size(360, 125));
//	////resize(image2, image2, Size(360, 125));
//
//
//	////threshold(image, image, 0, 255, CV_THRESH_BINARY_INV+CV_THRESH_OTSU);
//	////erode(image, image, element);
//	////erode(image, image, element);
//	////dilate(image, image, element);
//
//	//			//ROTATING THE IMAGE:
//	////int len = std::max(image.cols, image.rows);
// ////   cv::Point2f pt(len/2., len/2.);
// ////   cv::Mat r = cv::getRotationMatrix2D(pt, 5, 1.0);
//	////cv::warpAffine(image2, image2, r, cv::Size(len, len));
//
//	//vector<vector<Point> > contours;
//	//vector<Vec4i> hierarchy;
//	//findContours( image, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
//
//	//vector<RotatedRect> minRect( contours.size() );
//
//
//	//for( int i = 0; i < contours.size(); i++ )
// //   { minRect[i] = minAreaRect( Mat(contours[i]) );}
//
//
//	////for( int i = 0; i< contours.size(); i++ )
//	////{
//	////	//if (minRect[i].boundingRect().area() < 5000 && minRect[i].boundingRect().area() > 500) {
//	////	Scalar color = Scalar( rng.uniform(0, 255), rng.uniform(0,255), rng.uniform(0,255) );
//	////	rectangle(image2, boundingRect(contours[i]),  Scalar(0,255,255),1, 8,0);
//	////	drawContours( d, contours, i, color, 2, 8, hierarchy, 0, Point() );
//	////	printf("%f", minRect[i].angle);
//	////	Point2f rect_points[4]; minRect[i].points( rect_points );
//	////	for( int j = 0; j < 4; j++ )
//	////	line( image2, rect_points[j], rect_points[(j+1)%4], Scalar(0,255,255), 1, 8 );
//	////	//}
//	////}
//
//	//cv::Mat quad = cv::Mat::zeros(dst.size().height, dst.size().width, CV_8UC3);
//
//	//std::vector<cv::Point2f> quad_pts;
//	//quad_pts.push_back(cv::Point2f(0, 0));
//	//quad_pts.push_back(cv::Point2f(quad.cols, 0));
//	//quad_pts.push_back(cv::Point2f(quad.cols, quad.rows));
//	//quad_pts.push_back(cv::Point2f(0, quad.rows));
//
//	//Point2f rect_points[4]; minRect[2].points( rect_points );
//	//std::vector<cv::Point2f> src_pts;
//	//src_pts.push_back(rect_points[2]);
//	//src_pts.push_back(rect_points[3]);
//	//src_pts.push_back(rect_points[0]);
//	//src_pts.push_back(rect_points[1]);
//
//
//	//Mat transmtx = getPerspectiveTransform(src_pts,quad_pts);
//	//warpPerspective(dst, quad, transmtx, quad.size());
//	/////*resize(image, image, Size(360, 125));
//	////resize(d, d, Size(360, 125));
//	////resize(image2, image2, Size(360, 125));*/
//	////
//	//image2 = quad.clone();
//	//image3 = quad.clone();
//	//element = getStructuringElement( MORPH_RECT , Size(3, 3)); // Create 
//	//threshold(quad, quad, 0, 255, CV_THRESH_BINARY_INV+CV_THRESH_OTSU);
//	//erode(quad, quad, element);
//
//	//findContours( quad, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
//
//	//vector<RotatedRect> minRect2( contours.size() );
//
//	//for( int i = 0; i < contours.size(); i++ )
// //   { minRect2[i] = minAreaRect( Mat(contours[i]) );}
//
//	//for( int i = 0; i< contours.size(); i++ )
//	//{
//	//	if (minRect2[i].boundingRect().width < 25 && minRect2[i].boundingRect().height < 60) {
//	//		Scalar color = Scalar( rng.uniform(0, 255), rng.uniform(0,255), rng.uniform(0,255) );
//	//		rectangle(image2, minRect2[i].boundingRect(),  Scalar(0,255,255),1, 8,0);
//	//		drawContours( d, contours, i, color, 2, 8, hierarchy, 0, Point() );
//	//		printf("%f  %f  .. ", minRect2[i].size.width, minRect2[i].size.height);
//	//		Point2f rect_points[4]; minRect2[i].points( rect_points );
//	//		for( int j = 0; j < 4; j++ )
//	//		line( image2, rect_points[j], rect_points[(j+1)%4], Scalar(0,255,255), 1, 8 );
//	//	}
//	//}
//
//	//cv::Rect myROI(10, 10, 100, 100);
//	//Mat c = image3(minRect2[1].boundingRect());
//	//
//	//Mat f = imread("F.jpg", CV_LOAD_IMAGE_GRAYSCALE);
//	//resize(c,c, f.size());
//	//Mat res = f - c;
//	//int fres = countNonZero(res);
//	//double percent = (double) fres / (f.size().width*f.size().height);
//	//printf("%f .. ", percent);
//	//imshow( "Number Plate", quad);
//	//imshow( "Number Plate1", image2);
//	//imshow( "Number Plate2", c);
//	waitKey(0);
//	return 0;
//}

//Mat doPerspective(Mat p) {
//	
//	Mat plate = p.clone();
//	Mat plate2 = p.clone();
//
//	threshold(plate2, plate2, 0, 255, THRESH_OTSU);
//
//	vector<vector<Point> > contours;
//	vector<Vec4i> hierarchy;
//	findContours( plate2, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
//	
//	vector<RotatedRect> minRect( contours.size() );
//	vector<int> rectsIndex;
//
//	for( int i = 0; i < contours.size(); i++ )
//     { minRect[i] = minAreaRect( Mat(contours[i]) );}
//
//	Point r = contours[0];
//	for( int i = 0; i< contours.size(); i++ )
//	{
//		if(contourArea(contours[i]) > contourArea(r))
//			//rectsIndex.push_back(i);
//			r = contours[i];
//	}
//
//	int len = std::max(plate2.cols, plate2.rows);
//    cv::Point2f pt(len/2., len/2.);
//	cv::Mat ro = cv::getRotationMatrix2D(pt, 90+r.angle, 1.0);
//	cv::warpAffine(plate, plate, ro, cv::Size(len, len));
//	imshow("k", plate);
//	printf("%f", r.angle);
//	return plate;
//}


// CHARACTER RECOGNITION ALGORITHM STARTS HERE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
string ocr(Mat plate) {
	
	Mat a = imread("A.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat b = imread("B.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat c = imread("C.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat d = imread("D.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat e = imread("E.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat f = imread("F.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat g = imread("G.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat h = imread("H.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat j = imread("J.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat s = imread("S.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat five = imread("5.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat nine = imread("9.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat seven = imread("7.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat t = imread("T.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat l = imread("L.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat six = imread("6.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat one = imread("1.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat k = imread("K.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat zero = imread("0.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat two = imread("2.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat o = imread("O.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat four = imread("4.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat eight = imread("8.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat w = imread("W.jpg", CV_LOAD_IMAGE_GRAYSCALE);
	Mat three = imread("3.jpg", CV_LOAD_IMAGE_GRAYSCALE);

	threshold(a, a, 127, 255, THRESH_BINARY_INV);
	threshold(b, b, 127, 255, THRESH_BINARY_INV);
	threshold(c, c, 127, 255, THRESH_BINARY_INV);
	threshold(d, d, 127, 255, THRESH_BINARY_INV);
	threshold(e, e, 127, 255, THRESH_BINARY_INV);
	threshold(f, f, 127, 255, THRESH_BINARY_INV);
	threshold(g, g, 127, 255, THRESH_BINARY_INV);
	threshold(h, h, 127, 255, THRESH_BINARY_INV);
	threshold(j, j, 127, 255, THRESH_BINARY_INV);
	threshold(s, s, 127, 255, THRESH_BINARY_INV);
	threshold(five, five, 127, 255, THRESH_BINARY_INV);
	threshold(nine, nine, 127, 255, THRESH_BINARY_INV);
	threshold(seven, seven, 127, 255, THRESH_BINARY_INV);
	threshold(t, t, 127, 255, THRESH_BINARY_INV);
	threshold(l, l, 127, 255, THRESH_BINARY_INV);
	threshold(six, six, 127, 255, THRESH_BINARY_INV);
	threshold(one, one, 127, 255, THRESH_BINARY_INV);
	threshold(k, k, 127, 255, THRESH_BINARY_INV);
	threshold(zero, zero, 127, 255, THRESH_BINARY_INV);
	threshold(two, two, 127, 255, THRESH_BINARY_INV);
	threshold(o, o, 127, 255, THRESH_BINARY_INV);
	threshold(four, four, 127, 255, THRESH_BINARY_INV);
	threshold(o, o, 127, 255, THRESH_BINARY_INV);
	threshold(eight, eight, 127, 255, THRESH_BINARY_INV);
	threshold(w, w, 127, 255, THRESH_BINARY_INV);
	threshold(three, three, 127, 255, THRESH_BINARY_INV);

	vector<Mat> chars_nohole;
	vector<Mat> chars_onehole;
	vector<Mat> chars_twoholes;

	chars_nohole.push_back(three);
	chars_nohole.push_back(c);
	chars_nohole.push_back(e);
	chars_nohole.push_back(f);
	chars_nohole.push_back(w);
	chars_nohole.push_back(g);
	chars_nohole.push_back(h);
	chars_nohole.push_back(j);
	chars_nohole.push_back(s);
	chars_nohole.push_back(five);
	chars_nohole.push_back(seven);
	chars_nohole.push_back(t);
	chars_nohole.push_back(l);
	chars_nohole.push_back(one);
	chars_nohole.push_back(k);
	chars_nohole.push_back(two);

	chars_onehole.push_back(nine);
	chars_onehole.push_back(a);
	chars_onehole.push_back(six);
	chars_onehole.push_back(o);
	chars_onehole.push_back(d);
	chars_onehole.push_back(four);

	chars_twoholes.push_back(eight);
	chars_twoholes.push_back(b);
	chars_twoholes.push_back(zero);


	Mat plate2 = plate.clone();
	
	threshold(plate, plate, 0, 255, THRESH_BINARY_INV+THRESH_OTSU);	
	
	vector<vector<Point> > contours2;
	vector<Vec4i> hierarchy2;
	findContours( plate, contours2, hierarchy2, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
	vector<Mat> boundRect( contours2.size() );
	
	Mat drawing = Mat::zeros( plate.size(), CV_8UC3 );
	Mat drawing2 = Mat::zeros( plate.size(), CV_8UC3 );

	vector<vector<Point> > contours;
	vector<Vec4i> hierarchy;

	//double arc = arcLength(contours[0], true);
	//double arc2 = arcLength(contours2[0], true);
	//vector<Point> ax;
	//vector<Point> ax2;
	//approxPolyDP(contours[0], ax, arc*0.025, true);
	//approxPolyDP(contours2[0], ax2, arc2*0.025, true);

	//printf("\n arc: %f  arc2: %f  ax: %d   ax2: %d", arc, arc2, ax.size(), ax2.size());
	
	//for(int i=0; i < ax2.size(); i++) {

		//line(drawing, ax[i], ax[(i+1)%ax.size()], Scalar(0,0,255), 1, 8);
		//line(drawing2, ax2[i], ax2[(i+1)%ax2.size()], Scalar(0,0,255), 1, 8);
	//}
	Mat plate3;
	Mat gee;
	Mat tee;

	for(int i=0; i < contours2.size(); i++) {
		
		int low = 100000;
		int index = 100000;
		if(boundingRect(contours2[i]).area() > 500) {
			Mat temp = Mat(plate2(boundingRect(contours2[i])).rows, plate2(boundingRect(contours2[i])).cols, CV_16U);
			threshold(plate2(boundingRect(contours2[i])), temp, 0, 255, THRESH_BINARY_INV+THRESH_OTSU);
			plate3 = temp.clone();
			findContours( plate3, contours, hierarchy2, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
			//drawContours( drawing, contours2, i, Scalar(0,0,255), 2, 8, hierarchy, 0, Point() );

			resize(temp, temp, Size(23, 48));
			int lower = 0;

			if(contours.size() == 1) {
				for(int j=0; j < chars_nohole.size(); j++) {
					int pee = countNonZero(chars_nohole[j]);
					int kee = countNonZero(temp);

					//printf("\n %d %d", chars[j].rows, temp.rows);
					gee = temp&chars_nohole[j];

					int cee = abs(pee - countNonZero(gee));
					int lee = abs(kee - countNonZero(gee));
				//	printf("\n :: %d   %d  ", cee, lee);
					if((cee+lee) < low) {
						low = (lee+cee);
						index = j;
					}
				}
			} else if(contours.size() == 2) {
				for(int j=0; j < chars_onehole.size(); j++) {
					int pee = countNonZero(chars_onehole[j]);
					int kee = countNonZero(temp);

					//printf("\n %d %d", chars[j].rows, temp.rows);
					gee = temp&chars_onehole[j];
					
					int cee = abs(pee - countNonZero(gee));
					int lee = abs(kee - countNonZero(gee));

					if((cee+lee) < low) {
						low = (cee+lee);
						index = j;
					}
				}
			} else if(contours.size() > 2) {
				for(int j=0; j < chars_twoholes.size(); j++) {
					int pee = countNonZero(chars_nohole[j]);
					int kee = countNonZero(temp);

					//printf("\n %d %d", chars[j].rows, temp.rows);
					gee = temp&chars_twoholes[j];

					int cee = abs(pee - countNonZero(gee));
					int lee = abs(kee - countNonZero(gee));

					if((cee+lee) < low) {
						low = (cee+lee);
						index = j;
					}
				}
			}
			printf("\n INDEX: %d, MATCH x point: %d", index, boundingRect(contours2[i]).x);
		}
	}
	return "Plate Characters";
}
////CHARACTER RECOGNITION ALGORITHM ENDS HERE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX


int main() {

	Mat image = imread("f1.jpg", CV_LOAD_IMAGE_GRAYSCALE);  // INPUT TEST IMAGE
	Mat image2 = imread("f1.jpg", CV_LOAD_IMAGE_GRAYSCALE); // INPUT TEST IMAGE
	Mat image3 = imread("f1.jpg", CV_LOAD_IMAGE_GRAYSCALE); // INPUT TEST IMAGE
	Mat image4 = imread("f1.jpg"); // INPUT TEST IMAGE
	
	////START OF DETECTION ALGORITHM XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	GaussianBlur(image, image,	Size(5, 5), 0, 0); // Apply blur to smoothen the image
	Sobel(image, image, CV_8U, 1, 0, 3, 1, 0); // Apply sobel filter to detect edges in the image and make them dominant
	
	Mat element = getStructuringElement( MORPH_RECT, Size(24, 6)); // Create 
	morphologyEx(image, image, 3, element);
	
	threshold(image, image, 0, 255, CV_THRESH_OTSU);
	
	element = getStructuringElement( MORPH_RECT, Size(30, 6)); // Create 
	erode(image, image, element);
	element = getStructuringElement( MORPH_RECT, Size(40, 30));
	dilate(image, image, element);
	
	vector<vector<Point> > contours;
	vector<Vec4i> hierarchy;
	findContours( image, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
	vector<RotatedRect> minRect( contours.size() );
	Mat drawing = Mat::zeros( image.size(), CV_8UC3 );

	vector<int> rectsIndex;

	for( int i = 0; i< contours.size(); i++ )
	{
		minRect[i] = minAreaRect( Mat(contours[i]) );
		Scalar color = Scalar( rng.uniform(0, 255), rng.uniform(0,255), rng.uniform(0,255) );
		drawContours( drawing, contours, i, color, 2, 8, hierarchy, 0, Point() );
		
		Rect bR=minRect[i].boundingRect();
		double g = (double)bR.width/(double)bR.height;
		bool yes = minRect[i].size.width >= minRect[i].size.height;
		
		if ((abs(minRect[i].angle) > 75.0 || abs(minRect[i].angle) < 15.0) && (bR.area() > 4000.0) && (bR.area() < 50000.0) && (g > 1.5) && (g < 4.0)) {
			Point2f rect_points[4]; minRect[i].points( rect_points );
			for( int j = 0; j < 4; j++ )
				line( image4, rect_points[j], rect_points[(j+1)%4], Scalar(0,0,255), 6, 8 );

			rectsIndex.push_back(i);

		}
	}

	//// END OF DETECTION ALGORITHM XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX



	//// START OF TILT CORRECTION AND SEGMENTATION XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	
	vector<Mat> numberPlates;
	vector<int> rectsIndex2;
	if(rectsIndex.size() != 0) {
		for( int i = 0; i < rectsIndex.size(); i++ ) {  //

			Mat mayb = image2(minRect[rectsIndex[i]].boundingRect());
			Mat m = Mat(200, 100, CV_16U);
			resize(mayb, m, Size(200, 100));
			threshold(m, m, 0, 255, CV_THRESH_OTSU);
			Mat m2 = m.clone();

			vector<vector<Point> > contours;
			vector<Vec4i> hierarchy;
			findContours( m2, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
			vector<RotatedRect> minRect( contours.size() );
				
			int count = 0;
			bool midChar = false;
			vector<Point2f> chars;
			vector<Rect> boundRect( contours.size() );
		
			for( int j = 0; j< contours.size(); j++ )
			{
				 minRect[j] = minAreaRect( contours[j]);
				 boundRect[j] = boundingRect(contours[j]);

				 if(boundRect[j].width <= boundRect[j].height && boundRect[j].height < 100 && boundRect[j].height > 30) {

					 Point2i center = Point2i(boundRect[j].x + ((boundRect[j].width)/2), boundRect[j].y + ((boundRect[j].height)/2));

					 if(center.x < m.cols*0.70 && center.x > m.cols*0.30) {
						 midChar = true;
						 printf("\n%d  %d \n", boundRect[j].x, boundRect[j].y);
						 chars.push_back(center);
					 }
					 count++;
				 }
			}
			//printf("\nCount: %d ", count);	
			//EXPERIMENT
			/*if(count > 1 && count < 8 ) {
				minRect[midChar].points(rect_points);
				for (int g = 0; g < 4; g++) {
					if ((minRect[midChar].center.x -  rect_points[g].x) > 0 && (minRect[midChar].center.y - rect_points[g].y) > 0 && p1) {
						point1 = rect_points[g];
						p1 = false;
						printf("1 %f \n", point1.y);
					} else if ((minRect[midChar].center.x -  rect_points[g].x) < 0 && minRect[midChar].center.y - rect_points[g].y > 0 && p2) {
						point2 = rect_points[g];
						printf("2 %f \n\n\n", point2.y);
						p2 = false;
					}
				}
			}*/

			if(count > 1 && count <= 8 && midChar == true) {

				vector<Vec2f> lines, lines2, lines3;
				int linesCount1, linesCount2;
				Mat fixtilt = m.clone();
				Mat cdst = m.clone();

				//HoughLines(fixtilt, lines, 1, CV_PI/90, 100, 0, 0);
				Point2f first = chars[0];
				Point2f last = chars[0];

				if (chars.size() > 1) {
					for(int r=1; r < chars.size(); r++) {
						if (chars[r].x > last.x) {
							last = chars[r];
						} else if(chars[r].x < first.x) {
							first = chars[r];
						}
					}
				}

				//GRADIENT CALCULATION
				bool negativeSlope = false;
				float angle = 0;
				float x_diff = last.x - first.x;
				float y_diff = last.y - first.y;

				if(x_diff < 0 || y_diff < 0)
					negativeSlope = true;
			
				if(x_diff != 0) {
					angle = (cvFastArctan(abs(y_diff), abs(x_diff)));
					printf("\nANGLE: %f  \n", angle);
				}

				int len = std::max(fixtilt.cols, fixtilt.rows);
				cv::Point2f pt(len/2., len/2.);
				cv::Mat ro;
			
				if(negativeSlope == true){
					ro = cv::getRotationMatrix2D(pt, -angle, 1.0);
				} else {
					ro = cv::getRotationMatrix2D(pt, angle, 1.0); 
				}

				cv::warpAffine(fixtilt, fixtilt, ro, cv::Size(len, len));


				Mat fixtilt2 = fixtilt.clone();
				Mat cropthis = fixtilt.clone();
				vector<vector<Point> > contours;
				vector<Vec4i> hierarchy;
				findContours( fixtilt2, contours, hierarchy, CV_RETR_TREE, CV_CHAIN_APPROX_SIMPLE, Point(0, 0) );
				vector<RotatedRect> minRect( contours.size() );

				int cropY1 = 0;
				int cropY2 = 1;
				for( int l = 0; l< contours.size(); l++ )
				{
					//CHECK HERE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
					//minRect[l] = minAreaRect( Mat(contours[l]) );
					Point2i center = Point2i(boundingRect(contours[l]).x + ((boundingRect(contours[l]).width)/2), boundingRect(contours[l]).y + ((boundingRect(contours[l]).height)/2));
					if(center.x < fixtilt.cols*0.70 && center.x > fixtilt.cols*0.30 &&
						boundingRect(contours[l]).width <= boundingRect(contours[l]).height && boundingRect(contours[l]).height < 100 && boundingRect(contours[l]).height > 30) {
						cropY1 = boundingRect(contours[l]).tl().y;
						cropY2 = boundingRect(contours[l]).br().y;
						break;
					}
				}
			
				Mat cropped = cropthis(Rect(0, cropY1, cropthis.cols, (cropY2-cropY1)));//CROP PLATE HERE
			
				GaussianBlur(cropped, cropped, Size(3, 3), 0, 0);
				cropped.convertTo(cropped, -1, 1, -100);
				cropped.convertTo(cropped, -1, 2, 0);
			
				//imwrite("ex12.jpg", cropped);
				if(cropped.rows > 30) {
					resize(cropped, cropped, Size(200, 50));
					numberPlates.push_back(cropped);
				}
			}
		}
	}
	////END OF TILT CORRECTION XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	
	Mat a = imread("ex17.jpg", CV_LOAD_IMAGE_UNCHANGED);
	string s = ocr(a);
	//imshow("a", a);
	
	waitKey(0);
	return 0;
}